/*
 * Decompiled with CFR 0.152.
 */
package xmlstreamparser;

import threads.ReaderThreadListener;
import util.rzaUtil;
import util.rzaexept;
import xmlstreamparser.Node;
import xmlstreamparser.ParserListener;

public class Parser
implements ReaderThreadListener {
    ParserListener listener;
    rzaexept exceptionListener;
    StringBuffer buffer;
    int internal_state;
    boolean after_prolog;
    char code;
    Character ch;
    Node node;
    String attribute;
    int string_reader_target;
    static final int NODE_NAME = 0;
    static final int ATTRIBUTE_NAME = 1;
    static final int ATTRIBUTE_VALUE = 2;
    static final int NODE_TEXT = 3;
    boolean special_char = false;
    int string_reader_state = 0;
    static final int DEACTIVATED = 0;
    static final int READ_TEXT = 1;
    static final int READ_IDENT = 2;
    static final int READ_STRING1 = 3;
    static final int READ_STRING2 = 4;
    static final int READ_BLANK = 5;

    public Parser(ParserListener _listener, rzaexept _exceptionListener) {
        this.listener = _listener;
        this.exceptionListener = _exceptionListener;
        this.internal_state = 0;
        this.after_prolog = false;
        this.string_reader_state = 0;
        this.buffer = new StringBuffer();
        this.node = null;
    }

    public void read(Object reader, int _code) {
        this.code = (char)_code;
        this.ch = new Character(this.code);
        boolean eated = false;
        do {
            switch (this.string_reader_state) {
                case 0: {
                    eated = this.read_standard();
                    break;
                }
                case 1: {
                    eated = this.read_text();
                    break;
                }
                case 2: {
                    eated = this.read_ident();
                    break;
                }
                case 3: 
                case 4: {
                    eated = this.read_string();
                    break;
                }
                case 5: {
                    eated = this.read_blank();
                }
            }
        } while (!eated);
    }

    public boolean read_standard() {
        boolean eated = true;
        boolean isLetter = (this.code >= 'a' && this.code <= 'z') | (this.code >= 'A' && this.code <= 'Z');
        boolean isBlank = this.code == ' ' | this.code == '\n' | this.code == '\t' | this.code == '\r';
        switch (this.internal_state) {
            case 0: {
                if (this.code == '<') {
                    this.internal_state = 1;
                    break;
                }
                if (!isBlank) break;
                this.listener.blank();
                break;
            }
            case 1: {
                if (this.code == '?') {
                    if (this.after_prolog) break;
                    this.node = new Node(this.node);
                    this.internal_state = 2;
                    break;
                }
                if (this.code == '/') {
                    this.internal_state = 19;
                    break;
                }
                if (!isLetter) break;
                this.node = new Node(this.node);
                this.after_prolog = true;
                this.internal_state = 2;
                eated = false;
                break;
            }
            case 2: {
                this.string_reader_state = 2;
                this.string_reader_target = 0;
                this.internal_state = 3;
                break;
            }
            case 3: {
                this.string_reader_state = 5;
                this.internal_state = 17;
                break;
            }
            case 4: {
                this.string_reader_state = 2;
                this.string_reader_target = 1;
                this.internal_state = 18;
                break;
            }
            case 6: {
                if (this.code == '=') {
                    this.internal_state = 7;
                    break;
                }
                this.internal_state = 3;
                break;
            }
            case 7: {
                this.string_reader_state = 5;
                this.internal_state = 8;
                break;
            }
            case 8: {
                this.string_reader_state = this.code == '\'' ? 3 : (this.code == '\"' ? 4 : 2);
                this.string_reader_target = 2;
                this.internal_state = 3;
                break;
            }
            case 12: {
                if (this.code != '>') break;
                this.listener.prologEnd(this.node);
                this.node = this.node.parent;
                this.internal_state = 13;
                break;
            }
            case 13: {
                this.string_reader_state = 1;
                this.string_reader_target = 3;
                this.internal_state = 0;
                break;
            }
            case 14: {
                if (this.code != '>') break;
                this.listener.nodeEnd(this.node);
                this.node = this.node.parent;
                this.internal_state = 0;
                break;
            }
            case 17: {
                if (this.code == '?') {
                    this.internal_state = 12;
                    break;
                }
                if (this.code == '>') {
                    this.listener.nodeStart(this.node);
                    this.internal_state = 13;
                    break;
                }
                if (this.code == '/') {
                    this.internal_state = 14;
                    break;
                }
                this.internal_state = 4;
                eated = false;
                break;
            }
            case 18: {
                this.string_reader_state = 5;
                this.internal_state = 6;
                break;
            }
            case 19: {
                this.string_reader_state = 2;
                this.string_reader_target = 0;
                this.internal_state = 20;
                break;
            }
            case 20: {
                if (this.code != '>') break;
                this.listener.nodeEnd(this.node);
                this.node = this.node.parent;
                this.internal_state = 0;
            }
        }
        if (this.string_reader_state == 2 | this.string_reader_state == 1 | this.string_reader_state == 5) {
            eated = false;
        }
        return eated;
    }

    public boolean read_text() {
        boolean eated = false;
        if (this.code == '<') {
            this.read_map();
            this.buffer = new StringBuffer();
            this.string_reader_state = 0;
        } else {
            this.buffer.append(this.code);
            eated = true;
        }
        return eated;
    }

    public boolean read_ident() {
        boolean eated = false;
        if (this.code == ' ' | this.code == '\n' | this.code == '\t' | this.code == '=' | this.code == '>' | this.code == '/') {
            this.read_map();
            this.buffer = new StringBuffer();
            this.string_reader_state = 0;
        } else {
            this.buffer.append(this.code);
            eated = true;
        }
        return eated;
    }

    public boolean read_string() {
        if (this.special_char) {
            this.buffer.append(this.code);
            this.special_char = false;
        } else if (this.code == '\\') {
            this.special_char = true;
        } else if ((this.code == '\'' && this.string_reader_state == 3) | (this.code == '\"' && this.string_reader_state == 4)) {
            this.read_map();
            this.buffer = new StringBuffer();
            this.string_reader_state = 0;
        } else {
            this.buffer.append(this.code);
        }
        return true;
    }

    public boolean read_blank() {
        boolean eated = false;
        if (this.code == ' ' | this.code == '\n' | this.code == '\t' | this.code == '\r') {
            eated = true;
        } else {
            this.string_reader_state = 0;
        }
        return eated;
    }

    public void read_map() {
        String str = this.serverToUnicode(this.buffer.toString());
        switch (this.string_reader_target) {
            case 0: {
                this.node.name = str;
                break;
            }
            case 3: {
                if (this.node == null) break;
                this.node.text = rzaUtil.unescapeCDATA(str);
                break;
            }
            case 1: {
                this.attribute = str;
                this.node.attributes.put(str, "");
                break;
            }
            case 2: {
                this.node.attributes.put(this.attribute, str);
            }
        }
    }

    public String serverToUnicode(String s) {
        StringBuffer sb = new StringBuffer();
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            int cnt;
            if (a[i] < '\u0080') {
                sb.append(a[i]);
                continue;
            }
            if (a[i] > '\u00ef') {
                return s;
            }
            char t = a[i];
            if ((t | 0xE0) == t) {
                cnt = 2;
            } else if ((t | 0xC0) == t) {
                cnt = 1;
            } else {
                return s;
            }
            t = (char)(t & (1 << 6 - cnt) - 1);
            for (int j = 0; j < cnt; ++j) {
                if (++i == a.length || a[i] > '\u00bf') {
                    return s;
                }
                char k = t;
                t = (char)(t << 6 | a[i] & 0x3F);
            }
            sb.append(t);
        }
        return sb.toString();
    }
}

